-- NEGATIVE_INCIDENT_PARENT_GUARDIAN1_RCPNT
set sql_safe_updates=0;
SET @dtproviderIdNF=(SELECT id FROM dtprovider WHERE `dataProviderName`='NEGATIVE_INCIDENT_PARENT_GUARDIAN1_RCPNT');
UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T7.salutationName AS SALUTATION_NAME,
    T9.firstName AS FIRST_NAME,
    T9.lastName AS LAST_NAME,
	T9.emailId AS EMAIL_ID,
    T9.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T9.mobileNumber AS MOBILE_NO,
    T9.mobileCountryCode AS MOBILE_CODE,
    T9.printName AS PRINT_NAME,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    DATE_FORMAT(T1.incidentDate, '%d-%m-%Y') AS INCIDENT_DATE,
    T1.actionTaken AS ACTION_TAKEN,
    T1.reportedByUserName AS REPORTED_BY_USER,
    T2.itemValue AS INCIDENT_TYPE,
    T2.category AS INCIDENT_CATEGORY,
	T1.incidentDetails AS INCIDENT_DETAILS,
	T1.remarks AS REMARKS,
    T3.printName AS STUDENT_PRINT_NAME,
    T3.firstName AS STUDENT_FIRST_NAME,
    T3.lastName AS STUDENT_LAST_NAME
FROM
    incidents T1
        LEFT JOIN
    incident_types AS T2 ON T2.id = T1.incidentTypeId
        LEFT JOIN
    persons AS T3 ON T3.id = T1.personId
        LEFT JOIN
    students AS T4 ON T4.personId = T3.id
        LEFT JOIN
    admission T5 ON T5.studentId = T4.userId
        LEFT JOIN
    academy_location T6 ON T6.id = T5.academyLocationId
        LEFT JOIN
    person_relationships AS T8 ON T8.personId = T3.id
        LEFT JOIN
    persons AS T9 ON T9.id = T8.relatedPersonId
        LEFT JOIN
    salutations T7 ON T7.id = T9.salutationId
WHERE
    T1.id IN (namedParams)
        AND T5.activeStatus = TRUE
        AND T2.category = 'NEGATIVE' and T8.relationship = 'FATHER'",jsonString = '{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 4,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },        
        {
            "id": 5,
            "value": "salutationName",
            "resultKey": "SALUTATION_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 7
        },
	 	{
            "id": 9,
            "value": "INCIDENT_DATE",
            "resultKey": "INCIDENT_DATE",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "itemValue",
            "resultKey": "INCIDENT_TYPE",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "category",
            "resultKey": "INCIDENT_CATEGORY",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "actionTaken",
            "resultKey": "ACTION_TAKEN",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "reportedByUserName",
            "resultKey": "REPORTED_BY_USER",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "printName",
            "resultKey": "STUDENT_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "firstName",
            "resultKey": "STUDENT_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 14
        },
		{
            "id": 16,
            "value": "lastName",
            "resultKey": "STUDENT_LAST_NAME",
            "displayCode": "",
            "displayOrder": 15
        },
		{
            "id": 17,
            "value": "incidentDetails",
            "resultKey": "INCIDENT_DETAILS",
            "displayCode": "",
            "displayOrder": 16
        },
		{
            "id": 18,
            "value": "remarks",
            "resultKey": "REMARKS",
            "displayCode": "",
            "displayOrder": 17
        }
    ]
}' WHERE dataProviderId=@dtproviderIdNF;
        
        
-- POSITIVE_INCIDENT_PARENT_GUARDIAN2_RCPNT
SET @dtproviderIdPM=(SELECT id FROM dtprovider WHERE `dataProviderName`='POSITIVE_INCIDENT_PARENT_GUARDIAN2_RCPNT');
UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T7.salutationName AS SALUTATION_NAME,
    T9.firstName AS FIRST_NAME,
    T9.lastName AS LAST_NAME,
	T9.emailId AS EMAIL_ID,
    T9.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T9.mobileNumber AS MOBILE_NO,
    T9.mobileCountryCode AS MOBILE_CODE,
    T9.printName AS PRINT_NAME,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    DATE_FORMAT(T1.incidentDate, '%d-%m-%Y') AS INCIDENT_DATE,
    T1.actionTaken AS ACTION_TAKEN,
    T1.reportedByUserName AS REPORTED_BY_USER,
    T2.itemValue AS INCIDENT_TYPE,
    T2.category AS INCIDENT_CATEGORY,
	T1.incidentDetails AS INCIDENT_DETAILS,
	T1.remarks AS REMARKS,
    T3.printName AS STUDENT_PRINT_NAME,
    T3.firstName AS STUDENT_FIRST_NAME,
    T3.lastName AS STUDENT_LAST_NAME
FROM
    incidents T1
        LEFT JOIN
    incident_types AS T2 ON T2.id = T1.incidentTypeId
        LEFT JOIN
    persons AS T3 ON T3.id = T1.personId
        LEFT JOIN
    students AS T4 ON T4.personId = T3.id
        LEFT JOIN
    admission T5 ON T5.studentId = T4.userId
        LEFT JOIN
    academy_location T6 ON T6.id = T5.academyLocationId
        LEFT JOIN
    person_relationships AS T8 ON T8.personId = T3.id
        LEFT JOIN
    persons AS T9 ON T9.id = T8.relatedPersonId
        LEFT JOIN
    salutations T7 ON T7.id = T9.salutationId
WHERE
    T1.id IN (namedParams)
        AND T5.activeStatus = TRUE
        AND T2.category = 'POSITIVE' and T8.relationship = 'MOTHER'",jsonString = '{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 4,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },        
        {
            "id": 5,
            "value": "salutationName",
            "resultKey": "SALUTATION_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 7
        },
	 	{
            "id": 9,
            "value": "INCIDENT_DATE",
            "resultKey": "INCIDENT_DATE",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "itemValue",
            "resultKey": "INCIDENT_TYPE",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "category",
            "resultKey": "INCIDENT_CATEGORY",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "actionTaken",
            "resultKey": "ACTION_TAKEN",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "reportedByUserName",
            "resultKey": "REPORTED_BY_USER",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "printName",
            "resultKey": "STUDENT_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "firstName",
            "resultKey": "STUDENT_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 14
        },
		{
            "id": 16,
            "value": "lastName",
            "resultKey": "STUDENT_LAST_NAME",
            "displayCode": "",
            "displayOrder": 15
        },
		{
            "id": 17,
            "value": "incidentDetails",
            "resultKey": "INCIDENT_DETAILS",
            "displayCode": "",
            "displayOrder": 16
        },
		{
            "id": 18,
            "value": "remarks",
            "resultKey": "REMARKS",
            "displayCode": "",
            "displayOrder": 17
        }
    ]
}' WHERE dataProviderId=@dtproviderIdPM;
        
-- POSITIVE_INCIDENT_PARENT_GUARDIAN1_RCPNT
SET @dtproviderIdPF=(SELECT id FROM dtprovider WHERE `dataProviderName`='POSITIVE_INCIDENT_PARENT_GUARDIAN1_RCPNT');
UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T7.salutationName AS SALUTATION_NAME,
    T9.firstName AS FIRST_NAME,
    T9.lastName AS LAST_NAME,
	T9.emailId AS EMAIL_ID,
    T9.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T9.mobileNumber AS MOBILE_NO,
    T9.mobileCountryCode AS MOBILE_CODE,
    T9.printName AS PRINT_NAME,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    DATE_FORMAT(T1.incidentDate, '%d-%m-%Y') AS INCIDENT_DATE,
    T1.actionTaken AS ACTION_TAKEN,
    T1.reportedByUserName AS REPORTED_BY_USER,
    T2.itemValue AS INCIDENT_TYPE,
    T2.category AS INCIDENT_CATEGORY,
	T1.incidentDetails AS INCIDENT_DETAILS,
	T1.remarks AS REMARKS,
    T3.printName AS STUDENT_PRINT_NAME,
    T3.firstName AS STUDENT_FIRST_NAME,
    T3.lastName AS STUDENT_LAST_NAME
FROM
    incidents T1
        LEFT JOIN
    incident_types AS T2 ON T2.id = T1.incidentTypeId
        LEFT JOIN
    persons AS T3 ON T3.id = T1.personId
        LEFT JOIN
    students AS T4 ON T4.personId = T3.id
        LEFT JOIN
    admission T5 ON T5.studentId = T4.userId
        LEFT JOIN
    academy_location T6 ON T6.id = T5.academyLocationId
        LEFT JOIN
    person_relationships AS T8 ON T8.personId = T3.id
        LEFT JOIN
    persons AS T9 ON T9.id = T8.relatedPersonId
        LEFT JOIN
    salutations T7 ON T7.id = T9.salutationId
WHERE
    T1.id IN (namedParams)
        AND T5.activeStatus = TRUE
        AND T2.category = 'POSITIVE' and T8.relationship = 'FATHER'",jsonString = '{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 4,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },        
        {
            "id": 5,
            "value": "salutationName",
            "resultKey": "SALUTATION_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 7
        },
	 	{
            "id": 9,
            "value": "INCIDENT_DATE",
            "resultKey": "INCIDENT_DATE",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "itemValue",
            "resultKey": "INCIDENT_TYPE",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "category",
            "resultKey": "INCIDENT_CATEGORY",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "actionTaken",
            "resultKey": "ACTION_TAKEN",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "reportedByUserName",
            "resultKey": "REPORTED_BY_USER",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "printName",
            "resultKey": "STUDENT_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "firstName",
            "resultKey": "STUDENT_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 14
        },
		{
            "id": 16,
            "value": "lastName",
            "resultKey": "STUDENT_LAST_NAME",
            "displayCode": "",
            "displayOrder": 15
        },
		{
            "id": 17,
            "value": "incidentDetails",
            "resultKey": "INCIDENT_DETAILS",
            "displayCode": "",
            "displayOrder": 16
        },
		{
            "id": 18,
            "value": "remarks",
            "resultKey": "REMARKS",
            "displayCode": "",
            "displayOrder": 17
        }
    ]
}' WHERE dataProviderId=@dtproviderIdPF;
        
        
-- NEGATIVE_INCIDENT_PARENT_GUARDIAN2_RCPNT
        
SET @dtproviderIdNM=(SELECT id FROM dtprovider WHERE `dataProviderName`='NEGATIVE_INCIDENT_PARENT_GUARDIAN2_RCPNT');
UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T7.salutationName AS SALUTATION_NAME,
    T9.firstName AS FIRST_NAME,
    T9.lastName AS LAST_NAME,
	T9.emailId AS EMAIL_ID,
    T9.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T9.mobileNumber AS MOBILE_NO,
    T9.mobileCountryCode AS MOBILE_CODE,
    T9.printName AS PRINT_NAME,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    DATE_FORMAT(T1.incidentDate, '%d-%m-%Y') AS INCIDENT_DATE,
    T1.actionTaken AS ACTION_TAKEN,
    T1.reportedByUserName AS REPORTED_BY_USER,
    T2.itemValue AS INCIDENT_TYPE,
    T2.category AS INCIDENT_CATEGORY,
	T1.incidentDetails AS INCIDENT_DETAILS,
	T1.remarks AS REMARKS,
    T3.printName AS STUDENT_PRINT_NAME,
    T3.firstName AS STUDENT_FIRST_NAME,
    T3.lastName AS STUDENT_LAST_NAME
FROM
    incidents T1
        LEFT JOIN
    incident_types AS T2 ON T2.id = T1.incidentTypeId
        LEFT JOIN
    persons AS T3 ON T3.id = T1.personId
        LEFT JOIN
    students AS T4 ON T4.personId = T3.id
        LEFT JOIN
    admission T5 ON T5.studentId = T4.userId
        LEFT JOIN
    academy_location T6 ON T6.id = T5.academyLocationId
        LEFT JOIN
    person_relationships AS T8 ON T8.personId = T3.id
        LEFT JOIN
    persons AS T9 ON T9.id = T8.relatedPersonId
        LEFT JOIN
    salutations T7 ON T7.id = T9.salutationId
WHERE
    T1.id IN (namedParams)
        AND T5.activeStatus = TRUE
        AND T2.category = 'NEGATIVE' and T8.relationship = 'MOTHER'",jsonString = '{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 4,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },        
        {
            "id": 5,
            "value": "salutationName",
            "resultKey": "SALUTATION_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 7
        },
	 	{
            "id": 9,
            "value": "INCIDENT_DATE",
            "resultKey": "INCIDENT_DATE",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "itemValue",
            "resultKey": "INCIDENT_TYPE",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "category",
            "resultKey": "INCIDENT_CATEGORY",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "actionTaken",
            "resultKey": "ACTION_TAKEN",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "reportedByUserName",
            "resultKey": "REPORTED_BY_USER",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "printName",
            "resultKey": "STUDENT_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "firstName",
            "resultKey": "STUDENT_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 14
        },
		{
            "id": 16,
            "value": "lastName",
            "resultKey": "STUDENT_LAST_NAME",
            "displayCode": "",
            "displayOrder": 15
        },
		{
            "id": 17,
            "value": "incidentDetails",
            "resultKey": "INCIDENT_DETAILS",
            "displayCode": "",
            "displayOrder": 16
        },
		{
            "id": 18,
            "value": "remarks",
            "resultKey": "REMARKS",
            "displayCode": "",
            "displayOrder": 17
        }
    ]
}' WHERE dataProviderId=@dtproviderIdNM;
          
        
-- POSITIVE_INCIDENT_LOCAL_GUARDIAN_RCPNT       
        
SET @dtproviderIdPLG=(SELECT id FROM dtprovider WHERE `dataProviderName`='POSITIVE_INCIDENT_LOCAL_GUARDIAN_RCPNT');
UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T7.salutationName AS SALUTATION_NAME,
    T9.firstName AS FIRST_NAME,
    T9.lastName AS LAST_NAME,
	T9.emailId AS EMAIL_ID,
    T9.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T9.mobileNumber AS MOBILE_NO,
    T9.mobileCountryCode AS MOBILE_CODE,
    T9.printName AS PRINT_NAME,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    DATE_FORMAT(T1.incidentDate, '%d-%m-%Y') AS INCIDENT_DATE,
    T1.actionTaken AS ACTION_TAKEN,
    T1.reportedByUserName AS REPORTED_BY_USER,
    T2.itemValue AS INCIDENT_TYPE,
    T2.category AS INCIDENT_CATEGORY,
	T1.incidentDetails AS INCIDENT_DETAILS,
	T1.remarks AS REMARKS,
    T3.printName AS STUDENT_PRINT_NAME,
    T3.firstName AS STUDENT_FIRST_NAME,
    T3.lastName AS STUDENT_LAST_NAME
FROM
    incidents T1
        LEFT JOIN
    incident_types AS T2 ON T2.id = T1.incidentTypeId
        LEFT JOIN
    persons AS T3 ON T3.id = T1.personId
        LEFT JOIN
    students AS T4 ON T4.personId = T3.id
        LEFT JOIN
    admission T5 ON T5.studentId = T4.userId
        LEFT JOIN
    academy_location T6 ON T6.id = T5.academyLocationId
        LEFT JOIN
    person_relationships AS T8 ON T8.personId = T3.id
        LEFT JOIN
    persons AS T9 ON T9.id = T8.relatedPersonId
        LEFT JOIN
    salutations T7 ON T7.id = T9.salutationId
WHERE
    T1.id IN (namedParams)
        AND T5.activeStatus = TRUE
        AND T2.category = 'POSITIVE' and T8.relationship = 'LOCAL_GUARDIAN'",jsonString = '{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 4,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },        
        {
            "id": 5,
            "value": "salutationName",
            "resultKey": "SALUTATION_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 7
        },
	 	{
            "id": 9,
            "value": "INCIDENT_DATE",
            "resultKey": "INCIDENT_DATE",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "itemValue",
            "resultKey": "INCIDENT_TYPE",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "category",
            "resultKey": "INCIDENT_CATEGORY",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "actionTaken",
            "resultKey": "ACTION_TAKEN",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "reportedByUserName",
            "resultKey": "REPORTED_BY_USER",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "printName",
            "resultKey": "STUDENT_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "firstName",
            "resultKey": "STUDENT_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 14
        },
		{
            "id": 16,
            "value": "lastName",
            "resultKey": "STUDENT_LAST_NAME",
            "displayCode": "",
            "displayOrder": 15
        },
		{
            "id": 17,
            "value": "incidentDetails",
            "resultKey": "INCIDENT_DETAILS",
            "displayCode": "",
            "displayOrder": 16
        },
		{
            "id": 18,
            "value": "remarks",
            "resultKey": "REMARKS",
            "displayCode": "",
            "displayOrder": 17
        }
    ]
}' WHERE dataProviderId=@dtproviderIdPLG;
        
        
-- NEGATIVE_INCIDENT_LOCAL_GUARDIAN_RCPNT         
        
SET @dtproviderIdNLG=(SELECT id FROM dtprovider WHERE `dataProviderName`='NEGATIVE_INCIDENT_LOCAL_GUARDIAN_RCPNT');
UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T7.salutationName AS SALUTATION_NAME,
    T9.firstName AS FIRST_NAME,
    T9.lastName AS LAST_NAME,
	T9.emailId AS EMAIL_ID,
    T9.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T9.mobileNumber AS MOBILE_NO,
    T9.mobileCountryCode AS MOBILE_CODE,
    T9.printName AS PRINT_NAME,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    DATE_FORMAT(T1.incidentDate, '%d-%m-%Y') AS INCIDENT_DATE,
    T1.actionTaken AS ACTION_TAKEN,
    T1.reportedByUserName AS REPORTED_BY_USER,
    T2.itemValue AS INCIDENT_TYPE,
    T2.category AS INCIDENT_CATEGORY,
	T1.incidentDetails AS INCIDENT_DETAILS,
	T1.remarks AS REMARKS,
    T3.printName AS STUDENT_PRINT_NAME,
    T3.firstName AS STUDENT_FIRST_NAME,
    T3.lastName AS STUDENT_LAST_NAME
FROM
    incidents T1
        LEFT JOIN
    incident_types AS T2 ON T2.id = T1.incidentTypeId
        LEFT JOIN
    persons AS T3 ON T3.id = T1.personId
        LEFT JOIN
    students AS T4 ON T4.personId = T3.id
        LEFT JOIN
    admission T5 ON T5.studentId = T4.userId
        LEFT JOIN
    academy_location T6 ON T6.id = T5.academyLocationId
        LEFT JOIN
    person_relationships AS T8 ON T8.personId = T3.id
        LEFT JOIN
    persons AS T9 ON T9.id = T8.relatedPersonId
        LEFT JOIN
    salutations T7 ON T7.id = T9.salutationId
WHERE
    T1.id IN (namedParams)
        AND T5.activeStatus = TRUE
        AND T2.category = 'NEGATIVE' and T8.relationship = 'LOCAL_GUARDIAN'",jsonString = '{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 4,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },        
        {
            "id": 5,
            "value": "salutationName",
            "resultKey": "SALUTATION_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 7
        },
	 	{
            "id": 9,
            "value": "INCIDENT_DATE",
            "resultKey": "INCIDENT_DATE",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "itemValue",
            "resultKey": "INCIDENT_TYPE",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "category",
            "resultKey": "INCIDENT_CATEGORY",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "actionTaken",
            "resultKey": "ACTION_TAKEN",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "reportedByUserName",
            "resultKey": "REPORTED_BY_USER",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "printName",
            "resultKey": "STUDENT_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "firstName",
            "resultKey": "STUDENT_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 14
        },
		{
            "id": 16,
            "value": "lastName",
            "resultKey": "STUDENT_LAST_NAME",
            "displayCode": "",
            "displayOrder": 15
        },
		{
            "id": 17,
            "value": "incidentDetails",
            "resultKey": "INCIDENT_DETAILS",
            "displayCode": "",
            "displayOrder": 16
        },
		{
            "id": 18,
            "value": "remarks",
            "resultKey": "REMARKS",
            "displayCode": "",
            "displayOrder": 17
        }
    ]
}' WHERE dataProviderId=@dtproviderIdNLG;
               
     
-- POSITIVE_INCIDENT_ALOWNER_RCPNT
        
SET @dtproviderIdPAO=(SELECT id FROM dtprovider WHERE `dataProviderName`='POSITIVE_INCIDENT_ALOWNER_RCPNT');
UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T11.salutationName AS SALUTATION_NAME,
    T10.firstName AS FIRST_NAME,
    T10.lastName AS LAST_NAME,
    T10.emailId AS EMAIL_ID,
    T10.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T10.mobileNumber AS MOBILE_NO,
    T10.mobileCountryCode AS MOBILE_CODE,
    T10.printName AS PRINT_NAME,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    DATE_FORMAT(T1.incidentDate, '%d-%m-%Y') AS INCIDENT_DATE,
    T1.actionTaken AS ACTION_TAKEN,
    T1.reportedByUserName AS REPORTED_BY_USER,
    T2.itemValue AS INCIDENT_TYPE,
    T2.category AS INCIDENT_CATEGORY,
	T1.incidentDetails AS INCIDENT_DETAILS,
	T1.remarks AS REMARKS,
    T3.printName AS STUDENT_PRINT_NAME,
    T3.firstName AS STUDENT_FIRST_NAME,
    T3.lastName AS STUDENT_LAST_NAME
FROM
    incidents T1
        LEFT JOIN
    incident_types AS T2 ON T2.id = T1.incidentTypeId
        LEFT JOIN
    persons AS T3 ON T3.id = T1.personId
        LEFT JOIN
    students AS T4 ON T4.personId = T3.id
        LEFT JOIN
    admission T5 ON T5.studentId = T4.userId
        LEFT JOIN
    academy_location T6 ON T6.id = T5.academyLocationId
        LEFT JOIN
    academy_location_purpose T7 ON T7.academyLocationId = T6.id
        LEFT OUTER JOIN
    users T8 ON T7.ownerId = T8.id
        INNER JOIN
    staffs T9 ON T9.userId = T8.id
        LEFT OUTER JOIN
    persons T10 ON T9.personId = T10.id
     LEFT JOIN
    salutations T11 ON T11.id = T10.salutationId
WHERE
    T1.id IN (namedParams)
        AND T5.activeStatus = TRUE
        AND T2.category = 'POSITIVE'
        AND T7.purposeCode = 'COURSE_EXECUTION'",jsonString = '{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 4,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },        
        {
            "id": 5,
            "value": "salutationName",
            "resultKey": "SALUTATION_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 7
        },
	 	{
            "id": 9,
            "value": "INCIDENT_DATE",
            "resultKey": "INCIDENT_DATE",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "itemValue",
            "resultKey": "INCIDENT_TYPE",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "category",
            "resultKey": "INCIDENT_CATEGORY",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "actionTaken",
            "resultKey": "ACTION_TAKEN",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "reportedByUserName",
            "resultKey": "REPORTED_BY_USER",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "printName",
            "resultKey": "STUDENT_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "firstName",
            "resultKey": "STUDENT_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 14
        },
		{
            "id": 16,
            "value": "lastName",
            "resultKey": "STUDENT_LAST_NAME",
            "displayCode": "",
            "displayOrder": 15
        },
		{
            "id": 17,
            "value": "incidentDetails",
            "resultKey": "INCIDENT_DETAILS",
            "displayCode": "",
            "displayOrder": 16
        },
		{
            "id": 18,
            "value": "remarks",
            "resultKey": "REMARKS",
            "displayCode": "",
            "displayOrder": 17
        }
    ]
}' WHERE dataProviderId=@dtproviderIdPAO;
             

-- NEGATIVE_INCIDENT_ALOWNER_RCPNT        
        
SET @dtproviderIdNAO=(SELECT id FROM dtprovider WHERE `dataProviderName`='NEGATIVE_INCIDENT_ALOWNER_RCPNT');
UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T11.salutationName AS SALUTATION_NAME,
    T10.firstName AS FIRST_NAME,
    T10.lastName AS LAST_NAME,
    T10.emailId AS EMAIL_ID,
    T10.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T10.mobileNumber AS MOBILE_NO,
    T10.mobileCountryCode AS MOBILE_CODE,
    T10.printName AS PRINT_NAME,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    DATE_FORMAT(T1.incidentDate, '%d-%m-%Y') AS INCIDENT_DATE,
    T1.actionTaken AS ACTION_TAKEN,
    T1.reportedByUserName AS REPORTED_BY_USER,
    T2.itemValue AS INCIDENT_TYPE,
    T2.category AS INCIDENT_CATEGORY,
	T1.incidentDetails AS INCIDENT_DETAILS,
	T1.remarks AS REMARKS,
    T3.printName AS STUDENT_PRINT_NAME,
    T3.firstName AS STUDENT_FIRST_NAME,
    T3.lastName AS STUDENT_LAST_NAME
FROM
    incidents T1
        LEFT JOIN
    incident_types AS T2 ON T2.id = T1.incidentTypeId
        LEFT JOIN
    persons AS T3 ON T3.id = T1.personId
        LEFT JOIN
    students AS T4 ON T4.personId = T3.id
        LEFT JOIN
    admission T5 ON T5.studentId = T4.userId
        LEFT JOIN
    academy_location T6 ON T6.id = T5.academyLocationId
        LEFT JOIN
    academy_location_purpose T7 ON T7.academyLocationId = T6.id
        LEFT OUTER JOIN
    users T8 ON T7.ownerId = T8.id
        INNER JOIN
    staffs T9 ON T9.userId = T8.id
        LEFT OUTER JOIN
    persons T10 ON T9.personId = T10.id
     LEFT JOIN
    salutations T11 ON T11.id = T10.salutationId
WHERE
    T1.id IN (namedParams)
        AND T5.activeStatus = TRUE
        AND T2.category = 'NEGATIVE'
        AND T7.purposeCode = 'COURSE_EXECUTION'",jsonString = '{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 4,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },        
        {
            "id": 5,
            "value": "salutationName",
            "resultKey": "SALUTATION_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 7
        },
	 	{
            "id": 9,
            "value": "INCIDENT_DATE",
            "resultKey": "INCIDENT_DATE",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "itemValue",
            "resultKey": "INCIDENT_TYPE",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "category",
            "resultKey": "INCIDENT_CATEGORY",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "actionTaken",
            "resultKey": "ACTION_TAKEN",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "reportedByUserName",
            "resultKey": "REPORTED_BY_USER",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "printName",
            "resultKey": "STUDENT_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "firstName",
            "resultKey": "STUDENT_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 14
        },
		{
            "id": 16,
            "value": "lastName",
            "resultKey": "STUDENT_LAST_NAME",
            "displayCode": "",
            "displayOrder": 15
        },
		{
            "id": 17,
            "value": "incidentDetails",
            "resultKey": "INCIDENT_DETAILS",
            "displayCode": "",
            "displayOrder": 16
        },
		{
            "id": 18,
            "value": "remarks",
            "resultKey": "REMARKS",
            "displayCode": "",
            "displayOrder": 17
        }
    ]
}' WHERE dataProviderId=@dtproviderIdNAO;        
        

-- POSITIVE_INCIDENT_PRINCIPLE_RCPNT        
        
SET @dtproviderIdPP=(SELECT id FROM dtprovider WHERE `dataProviderName`='POSITIVE_INCIDENT_PRINCIPLE_RCPNT');
UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT
    T1.id AS ID,
    T11.salutationName AS SALUTATION_NAME,
    T10.firstName AS FIRST_NAME,
    T10.lastName AS LAST_NAME,
    T10.emailId AS EMAIL_ID,
    T10.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T10.mobileNumber AS MOBILE_NO,
    T10.mobileCountryCode AS MOBILE_CODE,
    T10.printName AS PRINT_NAME,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    DATE_FORMAT(T1.incidentDate, '%d-%m-%Y') AS INCIDENT_DATE,
    T1.actionTaken AS ACTION_TAKEN,
    T1.reportedByUserName AS REPORTED_BY_USER,
    T2.itemValue AS INCIDENT_TYPE,
    T2.category AS INCIDENT_CATEGORY,
	T1.incidentDetails AS INCIDENT_DETAILS,
	T1.remarks AS REMARKS,
    T3.printName AS STUDENT_PRINT_NAME,
    T3.firstName AS STUDENT_FIRST_NAME,
    T3.lastName AS STUDENT_LAST_NAME
FROM
    incidents T1
        LEFT JOIN
    incident_types AS T2 ON T2.id = T1.incidentTypeId
        LEFT JOIN
    persons AS T3 ON T3.id = T1.personId
        LEFT JOIN
    students AS T4 ON T4.personId = T3.id
        LEFT JOIN
    admission T5 ON T5.studentId = T4.userId
        LEFT JOIN
    program_batch_students pbs ON pbs.admissionId = T5.id
        inner JOIN
    sections sec ON sec.id = pbs.sectionId
        LEFT JOIN
    batches b ON b.id = pbs.programBatchId
        LEFT JOIN
    programs p ON p.id = b.programId
        LEFT JOIN
    program_group pg ON pg.id = p.programGroupId
        LEFT JOIN
    program_group_details pgd ON pgd.programGroupId = pg.id and pgd.academyLocationId = T5.academyLocationId
        LEFT JOIN
    academy_location T6 ON T6.id = T5.academyLocationId
        LEFT JOIN
    academy_location_purpose T7 ON T7.academyLocationId = T6.id
        left JOIN
    staffs T9 ON T9.userId = pgd.principalId
        LEFT OUTER JOIN
    persons T10 ON T9.personId = T10.id
        LEFT JOIN
    salutations T11 ON T11.id = T10.salutationId
WHERE
    T1.id IN (namedParams)
        AND T5.activeStatus = TRUE
       AND T2.category = 'POSITIVE'
        AND pbs.isCurrentSection = TRUE
        AND pbs.isCurrentPeriod = TRUE
        AND pbs.exitDate IS NULL",jsonString = '{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 4,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },        
        {
            "id": 5,
            "value": "salutationName",
            "resultKey": "SALUTATION_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 7
        },
	 	{
            "id": 9,
            "value": "INCIDENT_DATE",
            "resultKey": "INCIDENT_DATE",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "itemValue",
            "resultKey": "INCIDENT_TYPE",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "category",
            "resultKey": "INCIDENT_CATEGORY",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "actionTaken",
            "resultKey": "ACTION_TAKEN",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "reportedByUserName",
            "resultKey": "REPORTED_BY_USER",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "printName",
            "resultKey": "STUDENT_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "firstName",
            "resultKey": "STUDENT_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 14
        },
		{
            "id": 16,
            "value": "lastName",
            "resultKey": "STUDENT_LAST_NAME",
            "displayCode": "",
            "displayOrder": 15
        },
		{
            "id": 17,
            "value": "incidentDetails",
            "resultKey": "INCIDENT_DETAILS",
            "displayCode": "",
            "displayOrder": 16
        },
		{
            "id": 18,
            "value": "remarks",
            "resultKey": "REMARKS",
            "displayCode": "",
            "displayOrder": 17
        }
    ]
}' WHERE dataProviderId=@dtproviderIdPP;         
        
        
        
-- NEGATIVE_INCIDENT_PRINCIPLE_RCPNT        
        
SET @dtproviderIdNP=(SELECT id FROM dtprovider WHERE `dataProviderName`='NEGATIVE_INCIDENT_PRINCIPLE_RCPNT');
UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT
    T1.id AS ID,
    T11.salutationName AS SALUTATION_NAME,
    T10.firstName AS FIRST_NAME,
    T10.lastName AS LAST_NAME,
    T10.emailId AS EMAIL_ID,
    T10.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T10.mobileNumber AS MOBILE_NO,
    T10.mobileCountryCode AS MOBILE_CODE,
    T10.printName AS PRINT_NAME,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    DATE_FORMAT(T1.incidentDate, '%d-%m-%Y') AS INCIDENT_DATE,
    T1.actionTaken AS ACTION_TAKEN,
    T1.reportedByUserName AS REPORTED_BY_USER,
    T2.itemValue AS INCIDENT_TYPE,
    T2.category AS INCIDENT_CATEGORY,
	T1.incidentDetails AS INCIDENT_DETAILS,
	T1.remarks AS REMARKS,
    T3.printName AS STUDENT_PRINT_NAME,
    T3.firstName AS STUDENT_FIRST_NAME,
    T3.lastName AS STUDENT_LAST_NAME
FROM
    incidents T1
        LEFT JOIN
    incident_types AS T2 ON T2.id = T1.incidentTypeId
        LEFT JOIN
    persons AS T3 ON T3.id = T1.personId
        LEFT JOIN
    students AS T4 ON T4.personId = T3.id
        LEFT JOIN
    admission T5 ON T5.studentId = T4.userId
        LEFT JOIN
    program_batch_students pbs ON pbs.admissionId = T5.id
        inner JOIN
    sections sec ON sec.id = pbs.sectionId
        LEFT JOIN
    batches b ON b.id = pbs.programBatchId
        LEFT JOIN
    programs p ON p.id = b.programId
        LEFT JOIN
    program_group pg ON pg.id = p.programGroupId
        LEFT JOIN
    program_group_details pgd ON pgd.programGroupId = pg.id and pgd.academyLocationId = T5.academyLocationId
        LEFT JOIN
    academy_location T6 ON T6.id = T5.academyLocationId
        LEFT JOIN
    academy_location_purpose T7 ON T7.academyLocationId = T6.id
        left JOIN
    staffs T9 ON T9.userId = pgd.principalId
        LEFT OUTER JOIN
    persons T10 ON T9.personId = T10.id
        LEFT JOIN
    salutations T11 ON T11.id = T10.salutationId
WHERE
    T1.id IN (namedParams)
        AND T5.activeStatus = TRUE
       AND T2.category = 'NEGATIVE'
        AND pbs.isCurrentSection = TRUE
        AND pbs.isCurrentPeriod = TRUE
        AND pbs.exitDate IS NULL",jsonString = '{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 4,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },        
        {
            "id": 5,
            "value": "salutationName",
            "resultKey": "SALUTATION_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 7
        },
	 	{
            "id": 9,
            "value": "INCIDENT_DATE",
            "resultKey": "INCIDENT_DATE",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "itemValue",
            "resultKey": "INCIDENT_TYPE",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "category",
            "resultKey": "INCIDENT_CATEGORY",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "actionTaken",
            "resultKey": "ACTION_TAKEN",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "reportedByUserName",
            "resultKey": "REPORTED_BY_USER",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "printName",
            "resultKey": "STUDENT_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "firstName",
            "resultKey": "STUDENT_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 14
        },
		{
            "id": 16,
            "value": "lastName",
            "resultKey": "STUDENT_LAST_NAME",
            "displayCode": "",
            "displayOrder": 15
        },
		{
            "id": 17,
            "value": "incidentDetails",
            "resultKey": "INCIDENT_DETAILS",
            "displayCode": "",
            "displayOrder": 16
        },
		{
            "id": 18,
            "value": "remarks",
            "resultKey": "REMARKS",
            "displayCode": "",
            "displayOrder": 17
        }
    ]
}' WHERE dataProviderId=@dtproviderIdNP;         
        
        
      
        
-- POSITIVE_INCIDENT_CLASSTEACHER_RCPNT

SET @dtproviderIdPCT=(SELECT id FROM dtprovider WHERE `dataProviderName`='POSITIVE_INCIDENT_CLASSTEACHER_RCPNT');
UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT
    T1.id AS ID,
    T11.salutationName AS SALUTATION_NAME,
    T10.firstName AS FIRST_NAME,
    T10.lastName AS LAST_NAME,
    T10.emailId AS EMAIL_ID,
    T10.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T10.mobileNumber AS MOBILE_NO,
    T10.mobileCountryCode AS MOBILE_CODE,
    T10.printName AS PRINT_NAME,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    DATE_FORMAT(T1.incidentDate, '%d-%m-%Y') AS INCIDENT_DATE,
    T1.actionTaken AS ACTION_TAKEN,
    T1.reportedByUserName AS REPORTED_BY_USER,
    T2.itemValue AS INCIDENT_TYPE,
    T2.category AS INCIDENT_CATEGORY,
	T1.incidentDetails AS INCIDENT_DETAILS,
	T1.remarks AS REMARKS,
    T3.printName AS STUDENT_PRINT_NAME,
    T3.firstName AS STUDENT_FIRST_NAME,
    T3.lastName AS STUDENT_LAST_NAME
FROM
    incidents T1
        LEFT JOIN
    incident_types AS T2 ON T2.id = T1.incidentTypeId
        LEFT JOIN
    persons AS T3 ON T3.id = T1.personId
        LEFT JOIN
    students AS T4 ON T4.personId = T3.id
        LEFT JOIN
    admission T5 ON T5.studentId = T4.userId
        LEFT JOIN
    program_batch_students pbs ON pbs.admissionId = T5.id
        inner JOIN
    sections sec ON sec.id = pbs.sectionId
        LEFT JOIN
    academy_location T6 ON T6.id = T5.academyLocationId
        LEFT JOIN
    academy_location_purpose T7 ON T7.academyLocationId = T6.id
        Inner JOIN
    staffs T9 ON T9.userId = sec.facultyId
        LEFT OUTER JOIN
    persons T10 ON T9.personId = T10.id
        LEFT JOIN
    salutations T11 ON T11.id = T10.salutationId
WHERE
    T1.id IN (namedParams)
        AND T5.activeStatus = TRUE
		AND T2.category = 'POSITIVE'
        AND pbs.isCurrentSection = TRUE
        AND pbs.isCurrentPeriod = TRUE
        AND pbs.exitDate IS NULL",jsonString = '{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 4,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },        
        {
            "id": 5,
            "value": "salutationName",
            "resultKey": "SALUTATION_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 7
        },
	 	{
            "id": 9,
            "value": "INCIDENT_DATE",
            "resultKey": "INCIDENT_DATE",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "itemValue",
            "resultKey": "INCIDENT_TYPE",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "category",
            "resultKey": "INCIDENT_CATEGORY",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "actionTaken",
            "resultKey": "ACTION_TAKEN",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "reportedByUserName",
            "resultKey": "REPORTED_BY_USER",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "printName",
            "resultKey": "STUDENT_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "firstName",
            "resultKey": "STUDENT_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 14
        },
		{
            "id": 16,
            "value": "lastName",
            "resultKey": "STUDENT_LAST_NAME",
            "displayCode": "",
            "displayOrder": 15
        },
		{
            "id": 17,
            "value": "incidentDetails",
            "resultKey": "INCIDENT_DETAILS",
            "displayCode": "",
            "displayOrder": 16
        },
		{
            "id": 18,
            "value": "remarks",
            "resultKey": "REMARKS",
            "displayCode": "",
            "displayOrder": 17
        }
    ]
}' WHERE dataProviderId=@dtproviderIdPCT;
        
        
-- NEGATIVE_INCIDENT_CLASTEACHER_RCPNT        
        
SET @dtproviderIdNCT=(SELECT id FROM dtprovider WHERE `dataProviderName`='NEGATIVE_INCIDENT_CLASTEACHER_RCPNT');
UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT
    T1.id AS ID,
    T11.salutationName AS SALUTATION_NAME,
    T10.firstName AS FIRST_NAME,
    T10.lastName AS LAST_NAME,
    T10.emailId AS EMAIL_ID,
    T10.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T10.mobileNumber AS MOBILE_NO,
    T10.mobileCountryCode AS MOBILE_CODE,
    T10.printName AS PRINT_NAME,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    DATE_FORMAT(T1.incidentDate, '%d-%m-%Y') AS INCIDENT_DATE,
    T1.actionTaken AS ACTION_TAKEN,
    T1.reportedByUserName AS REPORTED_BY_USER,
    T2.itemValue AS INCIDENT_TYPE,
    T2.category AS INCIDENT_CATEGORY,
	T1.incidentDetails AS INCIDENT_DETAILS,
	T1.remarks AS REMARKS,
    T3.printName AS STUDENT_PRINT_NAME,
    T3.firstName AS STUDENT_FIRST_NAME,
    T3.lastName AS STUDENT_LAST_NAME
FROM
    incidents T1
        LEFT JOIN
    incident_types AS T2 ON T2.id = T1.incidentTypeId
        LEFT JOIN
    persons AS T3 ON T3.id = T1.personId
        LEFT JOIN
    students AS T4 ON T4.personId = T3.id
        LEFT JOIN
    admission T5 ON T5.studentId = T4.userId
        LEFT JOIN
    program_batch_students pbs ON pbs.admissionId = T5.id
        inner JOIN
    sections sec ON sec.id = pbs.sectionId
        LEFT JOIN
    academy_location T6 ON T6.id = T5.academyLocationId
        LEFT JOIN
    academy_location_purpose T7 ON T7.academyLocationId = T6.id
        Inner JOIN
    staffs T9 ON T9.userId = sec.facultyId
        LEFT OUTER JOIN
    persons T10 ON T9.personId = T10.id
        LEFT JOIN
    salutations T11 ON T11.id = T10.salutationId
WHERE
    T1.id IN (namedParams)
        AND T5.activeStatus = TRUE
		AND T2.category = 'NEGATIVE'
        AND pbs.isCurrentSection = TRUE
        AND pbs.isCurrentPeriod = TRUE
        AND pbs.exitDate IS NULL",jsonString = '{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 4,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },        
        {
            "id": 5,
            "value": "salutationName",
            "resultKey": "SALUTATION_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 7
        },
	 	{
            "id": 9,
            "value": "INCIDENT_DATE",
            "resultKey": "INCIDENT_DATE",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "itemValue",
            "resultKey": "INCIDENT_TYPE",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "category",
            "resultKey": "INCIDENT_CATEGORY",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "actionTaken",
            "resultKey": "ACTION_TAKEN",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "reportedByUserName",
            "resultKey": "REPORTED_BY_USER",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "printName",
            "resultKey": "STUDENT_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "firstName",
            "resultKey": "STUDENT_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 14
        },
		{
            "id": 16,
            "value": "lastName",
            "resultKey": "STUDENT_LAST_NAME",
            "displayCode": "",
            "displayOrder": 15
        },
		{
            "id": 17,
            "value": "incidentDetails",
            "resultKey": "INCIDENT_DETAILS",
            "displayCode": "",
            "displayOrder": 16
        },
		{
            "id": 18,
            "value": "remarks",
            "resultKey": "REMARKS",
            "displayCode": "",
            "displayOrder": 17
        }
    ]
}' WHERE dataProviderId=@dtproviderIdNCT;        
        
        
set sql_safe_updates=1;        
      